//$Id: CPoint.cpp,v 1.8 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPoint.hpp"
#include "../Basics/CString.hpp"
using Exponent::Basics::CString;
using Exponent::MathTools::CPoint;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CPoint, CCountedObject);

//	===========================================================================
CPoint::CPoint(const long x, const long y) : m_x(x), m_y(y)
{
	EXPONENT_CLASS_CONSTRUCTION(CPoint);
}

//	===========================================================================
CPoint::CPoint(const CPoint &point) : m_x(0), m_y(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CPoint);
	this->setPoint(point.getXPosition(), point.getYPosition());
}

//	===========================================================================
CPoint::~CPoint()
{
	EXPONENT_CLASS_DESTRUCTION(CPoint);
}

//	===========================================================================
CPoint &CPoint::operator = (const CPoint &point)
{
	this->setPoint(point.getXPosition(), point.getYPosition());
	return *this;
}

//	===========================================================================
bool CPoint::operator == (const CPoint &point)
{
	return ((m_x == point.m_x) && (m_y == point.m_y));
}

//	===========================================================================
bool CPoint::operator == (const CPoint &point) const
{
	return ((m_x == point.m_x) && (m_y == point.m_y));
}

//	===========================================================================
CPoint &CPoint::operator += (const CPoint &point)
{
	m_x += point.m_x;
	m_y += point.m_y;
	return *this;
}

//	===========================================================================
CPoint &CPoint::operator -= (const CPoint &point)
{
	m_x -= point.m_x;
	m_y -= point.m_y;
	return *this;
}

//	===========================================================================
void CPoint::offset(const CPoint &point)
{
	m_x += point.m_x;
	m_y += point.m_y;
}

//	===========================================================================
void CPoint::offset(const long x, const long y)
{
	m_x += x;
	m_y += y;
}

//	===========================================================================
bool CPoint::isStraightLine(const CPoint &point1, const CPoint &point2)
{
	return (point1.getXPosition() == point2.getXPosition() || point1.getYPosition() == point2.getYPosition());
}

//	===========================================================================
void CPoint::getObjectDescription(char *string, const long size) const
{
	CString description;
	description.setStringWithFormat("[%li,%li]", m_x, m_y);
	description.getString(string, size);
}